#include <bits/stdc++.h>
using namespace std;

struct triplet {
    double a, b;
    int i; 
};

bool choose(double X, double Y, double x, double y) {
    return X*X + Y*Y < (X+x)*(X+x) + (Y+y)*(Y+y);
}


bool cmpNorm(triplet a, triplet b) {
    return a.a*a.a + a.b*b.b > b.a*b.a + b.b*b.b;
}

int main() {
    int n;
    cin >> n;
    vector<triplet> coord(n);
    for (int i = 0; i < n; i++) {
        double x, y;
        cin >> x >> y;
        coord[i] = {x, y, i};
    }

    vector<int> res; 

    if (n <= 1000) {
        
        int bestDist = -1;
        vector<int> bestRes;

        for (int k = 0; k < n; k++) {
            double X = 0, Y = 0;
            vector<int> cur;
            for (int i = 0; i < n; i++) {
                int j = (i + k) % n; 
                if (choose(X, Y, coord[j].a, coord[j].b)) {
                    cur.push_back(coord[j].i);
                    X += coord[j].a;
                    Y += coord[j].b;
                }
            }
            int dist2 = X*X + Y*Y;
            if (dist2 > bestDist) {
                bestDist = dist2;
                bestRes = cur;
            }
        }
        res = bestRes;
    } else {
       
        sort(coord.begin(), coord.end(), [](triplet a, triplet b){
            return a.a*a.a + a.b*b.b > b.a*b.a + b.b*b.b;
        });

        double X = 0, Y = 0;
        for (auto &v : coord) {
            if (choose(X, Y, v.a, v.b)) {
                res.push_back(v.i);
                X += v.a;
                Y += v.b;
            }
        }
    }

    
    cout << res.size() << "\n";
    for (int i : res) cout << i+1 << " "; 
}